<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class PaginaCarrello {
	private $db;
	private $impostazioniEcommerce;
	private $datiCarrello;
	private $gestoreTraduzioni;
	private $lingua;

        function __construct($db,$idCarrello,$gestoreTraduzioni,$lingua) {
		$this->db = $db;
		$this->impostazioniEcommerce = $this->db->leggiSingolaRiga("geecEc_impostazioni",1);
		$this->datiCarrello          = $this->db->leggiSingolaRiga("geecEc_carrelli",$idCarrello);
		$this->gestoreTraduzioni     = $gestoreTraduzioni;
		$this->lingua		      = $lingua;
        }
        
        public function stampaDivBuonoSconto() {
            if($this->impostazioniEcommerce["nascondiDivSpedizione"]=="si") {
                echo"<hr>";
            }
			
            ?>
    		<div class="card card-body mb-3">
			<h6 class="mb-3 text-muted"><?= $this->gestoreTraduzioni->traduci("Hai un buono sconto?",$this->lingua) ?><i class="fas fa-percent float-right text-muted"></i> </h6>
			<div class="input-group">
				<input type="text" id="buonoSconto" class="form-control" placeholder="Se hai un codice sconto inseriscilo qui" value="<?= $this->datiCarrello["buonoSconto"] ?>">
				<div class="input-group-append"><button class="btn btn-primary" onclick="aggiungiBuonoSconto()">Convalida</button></div>
			</div>
		</div>
            <?php
			
            if($this->datiCarrello["buonoSconto"]!="") {
                echo"<div class=\"alert alert-success text-center mt-3\">
                    <h6 class=\"mb-0 text-success\">Con questo codice sconto risparmi {$this->datiCarrello["valoreBuonoSconto"]} €</h6>
                </div>";                
            }
	}
        
	public function stampaSelezioneSpedizione($peso) {
            if($this->impostazioniEcommerce["nascondiDivSpedizione"]=="si") {
                echo"<div class=\"d-none\">";
            }
            $capInZonaDisagiata = capInZonaDisagiata($this->db,$this->datiCarrello["capSpedizione"]);
            echo"<hr>
                <div class=\"card card-body mb-3\">
                    <h6 class=\"mb-3 text-muted\">Seleziona il metodo di spedizione<i class=\"fas fa-truck float-right text-muted\"></i> </h6>";

                    $importoFinaleProodtti = $this->datiCarrello["importoProdotti"] - $this->datiCarrello["valoreBuonoSconto"];
                    if($this->impostazioniEcommerce["attivaAreeGeografiche"]=="si") {
                        $queryMetodiSpedizione = "SELECT * FROM geecEc_metodiSpedizione WHERE disponibile LIKE 'si' AND {$importoFinaleProodtti}>=importoMinimoCarrello AND (areaGeografica=0 OR areaGeografica IN (SELECT id FROM geecEc_areeGeografiche WHERE nazioni LIKE '%{$this->datiCarrello["nazione"]}%'))";
                    }
                    else {
                        $queryMetodiSpedizione = "SELECT * FROM geecEc_metodiSpedizione WHERE disponibile LIKE 'si' AND {$importoFinaleProodtti}>=importoMinimoCarrello";
                    }
                    
                    $risMetodiSpedizione = $this->db->eseguiQueryLettura($queryMetodiSpedizione);
                    while($metodoSpedizione = $risMetodiSpedizione->fetch_assoc()) {
                        if($metodoSpedizione["categoria"]>0) {
                            // verifico la presenza nel carrello di prodotti di un'eventuale categoria (o sottocategories) impostata nel buono sconto
                            $categoriaMostrabile = false;
                            
                            $idCategorieAmmesse = recuperaIdSottoCategorie($this->db, "ecommerce", $metodoSpedizione["categoria"]);
                            $idCategorieAmmesse[count($idCategorieAmmesse)] = $metodoSpedizione["categoria"];
                            $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->datiCarrello["id"]}";
                            $risultatoProdottiCarrello = $this->db->eseguiQueryLettura($query);
                            while($prodottoOrdinato = $risultatoProdottiCarrello->fetch_assoc()) {
                                $datiProdottoOrdinato = $this->db->leggiSingolaRiga("geecEc_prodotti",$prodottoOrdinato["idProdotto"]);
                                if(in_array($datiProdottoOrdinato["categoria"], $idCategorieAmmesse)) {
                                    $categoriaMostrabile = true;
                                    break;
                                }
                            }
                            
                        }
                        else {
                            $categoriaMostrabile = true;
                        }
                        
                        $queryCostoSpedizione = "SELECT * FROM geecEc_fascePrezzoSpedizione WHERE idSpedizione={$metodoSpedizione["id"]} AND pesoMinimo<=$peso AND pesoMassimo>$peso LIMIT 1";
                        $risCostoSpedizione = $this->db->eseguiQueryLettura($queryCostoSpedizione);
                        if($risCostoSpedizione->num_rows>0) {
                            $datiFasciaPrezzo  = $risCostoSpedizione->fetch_assoc();
                            $importoSpedizione = ($capInZonaDisagiata) ? $datiFasciaPrezzo["costoZoneDisagiate"] : $datiFasciaPrezzo["costo"];
                        }
                        else {
                            $importoSpedizione = ($capInZonaDisagiata) ? $metodoSpedizione["costoZoneDisagiate"] : $metodoSpedizione["costo"];
                        }

                        if($metodoSpedizione["id"]==$this->datiCarrello["idSpedizione"]) {
                            echo"<div class=\"custom-control custom-radio\">
                                <input type=\"radio\" name=\"opzioniSpedizione\" id=\"spedizione{$metodoSpedizione["id"]}\" value=\"{$metodoSpedizione["id"]}\" class=\"custom-control-input\" onchange=\"{aggiornaSpedizione(this)}\" checked>
                                <label class=\"custom-control-label\" for=\"spedizione{$metodoSpedizione["id"]}\"><strong>{$metodoSpedizione["nome"]} <i class=\"fas fa-angle-right mx-2 fa-xs\"></i> <span class=\"text-muted\"> {$importoSpedizione} €</span></strong><p class=\"small mb-2\">{$metodoSpedizione["descrizione"]}</p></label>
                            </div>";
                        }
                        else if($categoriaMostrabile){
                            $spedizioneSelezionata = "";
                            if($this->datiCarrello["idSpedizione"]==0) {
                                $spedizioneSelezionata = "checked";
                                $this->aggiornaIdSpedizioneCarrello($metodoSpedizione,$importoSpedizione);
                                $this->datiCarrello["idSpedizione"]  = $metodoSpedizione["id"];
                                $this->datiCarrello["importoTotale"] = $this->datiCarrello["importoProdotti"] - $this->datiCarrello["valoreBuonoSconto"] + $importoSpedizione;
                            }

                            echo"<div class=\"custom-control custom-radio\">
                                <input type=\"radio\" name=\"opzioniSpedizione\" id=\"spedizione{$metodoSpedizione["id"]}\" value=\"{$metodoSpedizione["id"]}\" class=\"custom-control-input\" onchange=\"{aggiornaSpedizione(this)}\" $spedizioneSelezionata>
                                <label class=\"custom-control-label\" for=\"spedizione{$metodoSpedizione["id"]}\"><strong>{$metodoSpedizione["nome"]} <i class=\"fas fa-angle-right mx-2 fa-xs\"></i> <span class=\"text-muted\">$importoSpedizione €</span></strong><p class=\"small mb-2\">{$metodoSpedizione["descrizione"]}</p></label>
                            </div>";
                        }
                    }

                    /*
                     * Se dalle impostazioni delle spedizioni è stato abilitato il ritiro in sede 
                     * viene mostrato
                     */
                    if($this->impostazioniEcommerce["abilitaRitiroInSede"]=="si") {
                        $ritiroInSede = "";
                        if($this->datiCarrello["idSpedizione"]==0) {
                            $ritiroInSede = "checked";
                        }
                          echo"<div class=\"custom-control custom-radio\">
                            <input type=\"radio\" name=\"opzioniSpedizione\" id=\"ritiroInSede\" value=\"0\" class=\"custom-control-input\" onchange=\"{aggiornaSpedizione(this)}\" $ritiroInSede >
                            <label class=\"custom-control-label\" for=\"ritiroInSede\"><strong>Ritiro in sede</strong></label>
                        </div>";
                    }
            echo"</div>";
            
            if($this->impostazioniEcommerce["nascondiDivSpedizione"]=="si") {
                echo"</div>";
            }
	}

	function stampaMetodiPagamento() {
            $queryImpostazioniPagamento = "SELECT * FROM geecEc_impostazioniPagamenti WHERE id=1";
            $risImpostazioniPagmento = $this->db->eseguiQueryLettura($queryImpostazioniPagamento);
            $impostazioniPagamento = $risImpostazioniPagmento->fetch_assoc();
            
            $importoTotalePagamentoConsegna = $this->datiCarrello["importoTotale"] + $impostazioniPagamento["costoPagamentoConsegna"];
            ?>
            <div class="card card-body mb-3">
		<h6 class="mb-3 text-muted"><?= $this->gestoreTraduzioni->traduci("Seleziona il metodo di pagamento",$this->lingua) ?><i class="fas fa-euro-sign float-right text-muted"></i> </h6>
		<?php
                        if($impostazioniPagamento["attivaPaypal"]=="si") {
                           echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"customRadio1a\" name=\"opzioniPagamento\" value=\"paypal\" class=\"custom-control-input\" onclick=\"aggiornaLabelTotaleCarrello('paypal',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"customRadio1a\"><i class=\"fab fa-cc-paypal fa-fw mr-2\"></i> PayPal </label>
                                </div>";
                        }

                        if($impostazioniPagamento["attivaStripe"]=="si") {
                            echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"radioStripe\" name=\"opzioniPagamento\" value=\"stripe\" class=\"custom-control-input\" onclick=\"aggiornaLabelTotaleCarrello('stripe',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"radioStripe\"><i class=\"fab fa-cc-stripe fa-fw mr-2\"></i> Con carta di credito / Stripe </label>
                              </div>";
                        }
                        
                        if($impostazioniPagamento["attivaSatispay"]=="si") {
                            echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"radioStripe\" name=\"opzioniPagamento\" value=\"stripe\" class=\"custom-control-input\" onclick=\"aggiornaLabelTotaleCarrello('stripe',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"radioStripe\"><img class=\"mr-2\" src=\"template/img/iconeEsterne/satispay_icona.svg\" style=\"height:20px; width:20px;\"> Satispay</label>
                              </div>";
                        }
                        
                        if($impostazioniPagamento["attivaContoCorrente"]=="si") {
                            echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"customRadioBonifico\" name=\"opzioniPagamento\" value=\"bonifico\" class=\"custom-control-input\"  onclick=\"aggiornaLabelTotaleCarrello('bonifico',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"customRadioBonifico\"><i class=\"fas fa-university fa-fw mr-2\"></i> Bonifico </label>
                                </div>";
                        }

                        if($impostazioniPagamento["attivaPrepagata"]=="si") {
                           echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"customRadio3\" name=\"opzioniPagamento\" value=\"Carta prepagata\" class=\"custom-control-input\"  onclick=\"aggiornaLabelTotaleCarrello('Carta prepagata',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"customRadio3\"><i class=\"far fa-credit-card fa-fw mr-2\"></i> Carta prepagata </label>
                                </div>";
                        }

                        if($impostazioniPagamento["attivaPagamentoConsegna"]=="si") {
                            $stringaSupplemento = ($impostazioniPagamento["costoPagamentoConsegna"]>0) ? "(Supplemento di {$impostazioniPagamento["costoPagamentoConsegna"]} €)" : "";
                            echo"<div class=\"custom-control custom-radio mb-2\">
                                    <input type=\"radio\" id=\"customRadioConsegna\" name=\"opzioniPagamento\" value=\"Pagamento alla consegna\" class=\"custom-control-input\" onclick=\"aggiornaLabelTotaleCarrello('Pagamento alla consegna',{$this->datiCarrello["importoTotale"]},$importoTotalePagamentoConsegna)\">
                                    <label class=\"custom-control-label\" for=\"customRadioConsegna\"><i class=\"fas fa-cube fa-fw mr-2\"></i> Pagamento alla consegna $stringaSupplemento</label>
                                </div>";
                        }
                ?>
        	</div>
        	<?php
	}

        public function stampaModuloRegistrazione($sessioneUtente,$datiCookie) {
            if($sessioneUtente!=0) {
                $utente  = $this->db->leggiSingolaRiga("geec_utenti",$sessioneUtente);
                $nome 	  = ($this->datiCarrello["nome"]!="") ? $this->datiCarrello["nome"] : $utente["nome"];
                $cognome = ($this->datiCarrello["cognome"]!="") ? $this->datiCarrello["cognome"] :$utente["cognome"];
                $email   = ($this->datiCarrello["email"]!="") ? $this->datiCarrello["email"] :$utente["email"];
                $telefono= ($this->datiCarrello["telefono"]!="") ? $this->datiCarrello["telefono"] :$utente["telefono"];
                $via     = ($this->datiCarrello["indirizzo"]!="") ? $this->datiCarrello["indirizzo"] :$utente["via"];
                $citta   = ($this->datiCarrello["citta"]!="") ? $this->datiCarrello["citta"] :$utente["citta"];
                $cap     = ($this->datiCarrello["capSpedizione"]!="") ? $this->datiCarrello["capSpedizione"] :$utente["cap"];
                $codiceFiscale = ($this->datiCarrello["codiceFiscale"]!="") ? $this->datiCarrello["codiceFiscale"] :$utente["codiceFiscale"];
                $partitaIva    = ($this->datiCarrello["partitaIva"]!="") ? $this->datiCarrello["partitaIva"] :$utente["partitaIva"];
            }
            else {
                $nome    = $this->datiCarrello["nome"];
                $cognome = $this->datiCarrello["cognome"];
                $email   = $this->datiCarrello["email"];
                $telefono= $this->datiCarrello["telefono"];
                $via     = $this->datiCarrello["indirizzo"];
                $citta   = $this->datiCarrello["citta"];
                $cap     = $this->datiCarrello["capSpedizione"];
                $codiceFiscale = $this->datiCarrello["codiceFiscale"];
                $partitaIva    = $this->datiCarrello["partitaIva"];
            }
            
            ?>
            <div class="form-row">
	 	<div class="col-lg-7">
                    <div class="card card-body">
                        <h5><?= $this->gestoreTraduzioni->traduci("Inserisci i tuoi dati",$this->lingua) ?></h5>
                        <form>
                        	<div class="form-row row-cols-lg-2">
		                    <div class="form-group col">
		                        <label for="nome" ><?= $this->gestoreTraduzioni->traduci("Nome",$this->lingua) ?></label>
		                        <input type="text" class="form-control" id="nome" name="nome" placeholder="<?= $this->gestoreTraduzioni->traduci("Nome",$this->lingua) ?>" value="<?= $nome ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="cognome" ><?= $this->gestoreTraduzioni->traduci("Cognome",$this->lingua) ?></label>
		                        <input type="text" class="form-control" id="cognome" name="cognome" placeholder="<?= $this->gestoreTraduzioni->traduci("Cognome",$this->lingua) ?>" value="<?= $cognome ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="email" >Email</label>
		                        <input type="text" class="form-control" id="email" name="email" placeholder="Email" value="<?= $email ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>
		           <?php
		                    if($this->impostazioniEcommerce["richiediPassword"]=="si" && $sessioneUtente==0) {
		                        echo"<div class=\"form-group col\">
		                            <label for=\"passwordNuovoUtente\" >Password</label>
		                            <input type=\"text\" class=\"form-control\" id=\"passwordNuovoUtente\" name=\"password\" value=\"\"placeholder=\"Password\">
		                        </div>";
		                    }
		                    else {
		                        echo"<input type=\"text\" class=\"d-none\" id=\"passwordNuovoUtente\" name=\"password\" value=\"\">";
		                    }
		            
		                    echo"<div class=\"form-group col\">
		                        <label for=\"telefono\" >Telefono</label>
		                            <input type=\"text\" class=\"form-control\" id=\"telefono\" name=\"telefono\" placeholder=\"Telefono\" value=\"$telefono\" onchange=\"aggiornaDatiUtenteCarrello()\">
		                    </div>";
		                    
		                    if($this->impostazioniEcommerce["attivaAreeGeografiche"]=="si") {
		                        echo"<div class=\"input-group mb-3\">
		                           <div class=\"input-group-prepend\">
		                                <label class=\"input-group-text\">Nazione</label>
		                           </div>
		                           <select class=\"form-control py-3\" id=\"nazione\"  name=\"nazione\" onchange=\"aggiornaElencoSpedizioniDisponibili()\">";
		                                $arrayNazioni = explode(",",$this->impostazioniEcommerce["nazioniDaVisualizzare"]);
		                                foreach($arrayNazioni as $nazione) {
		                                    if($this->datiCarrello["nazione"]==$nazione) {
		                                        echo"<option value=\"$nazione\" selected>$nazione</option>";
		                                    }
		                                    else {
		                                        echo"<option value=\"$nazione\">$nazione</option>";
		                                    }
		                                }
		                        echo"</select>
		                        </div>";
				     }
		                     else {
		                         echo "<input type=\"text\" class=\"d-none\" id=\"nazione\" name=\"nazione\" value=\"{$this->datiCarrello["nazione"]}\">";
		                     }
			      ?>                           
		                    <div class="form-group col">
		                        <label for="citta" >Città</label>
		                        <input type="text" class="form-control" id="citta" name="citta" value="<?= $citta ?>" placeholder="Città" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="via" >Via</label>
		                        <input type="text" class="form-control" id="via" name="via" placeholder="Via" value="<?= $via ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="capSpedizione" >CAP</label>
		                        <input type="text" class="form-control" id="capSpedizione" name="cap" value="<?= $cap ?>" placeholder="CAP" onchange="aggiornaElencoSpedizioniDisponibili()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="codiceFiscale">Codice fiscale</label>
		                        <input type="text" class="form-control" id="codiceFiscale"  name="codiceFiscale" value="<?= $codiceFiscale ?>" placeholder="Codice fiscale" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>

		                    <div class="form-group col">
		                        <label for="partitaIva">Partita IVA</label>
		                        <input type="text" class="form-control" id="partitaIva" name="partitaIva" placeholder="Partita IVA" value="<?= $partitaIva ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>
		                    
		                    <div class="form-group col">
		                        <label for="partitaIva">Organizzazione</label>
		                        <input type="text" class="form-control" id="organizzazione" name="organizzazione" placeholder="Organizzazione" value="<?= $partitaIva ?>" onchange="aggiornaDatiUtenteCarrello()">
		                    </div>
                        	</div>
                            
				    <?php
				            $paginaCondizioni = $this->db->leggiSingolaRiga("geecB_contenuti",$datiCookie["paginaMaggioriInformazioni"]);
				            echo"<div class=\"custom-control custom-checkbox pl-0\">
				                    <label>
				                         <input type=\"checkbox\" id=\"accettoTerminiECondizioni\" name=\"accettoTerminiECondizioni\" > Accetto i <a href=articolo.php?id={$paginaCondizioni["id"]}&alias={$paginaCondizioni["alias"]}>termini e condizioni</a></input>
				                    </label>
				                </div>";
			 	
				            if($sessioneUtente==0 && $this->impostazioniEcommerce["registrazioneObbligatoria"]!="si") {
				                echo"<div class=\"custom-control custom-checkbox pl-0\">
				                        <label>
				                          <input type=\"checkbox\" id=\"creaAccount\" name=\"creaAccount\" value=\"si\" > Crea un account
				                        </label>
				                    </div>
				                    <p class=\"mb-0\">Registrandoti accetti il <a href=\"index.php?alias={$paginaCondizioni["alias"]}\">trattamento dei dati</a></p>";
				            }
				            else if($sessioneUtente==0) { // in questo caso la registrazione è obbligatoria e l'utente non è registrato, quindi va stampato questo
				            	echo"<input class=\"d-none\" type=\"checkbox\" id=\"creaAccount\" name=\"creaAccount\" value=\"si\" checked>";
				            }
				            else { // l'utente è già registrato, il campo input deve essere comunque stampato perché altrimenti la funzione darà un errore
				            	echo"<input class=\"d-none\" type=\"checkbox\" id=\"creaAccount\" name=\"creaAccount\" value=\"si\">";
				            }
				        ?>
                            </div>
                        </form>
                    </div>
            <?php
                    if($sessioneUtente==0) {
                        $this->stampaModuloLogin();
                    }
                    else {
                        $this->stampaBenvenuto($sessioneUtente);
                    }
            ?>
            </div>
            <?php
        }
        
        /*
         * Questo metodo viene chiamato quando l'utente arriva per la prima volta nella pagina carrello (ovvero il campo idSpedizione = 0) . 
         * Quando il sistema rileva che quella spedizione è adatta al carrello selezionato la imposta come di default e la aggiorna l'importo 
         * totale del carrello
         */
        function aggiornaIdSpedizioneCarrello($datiSpedizione,$importoSpedizione) {
            $importoTotale = $this->datiCarrello["importoProdotti"] - $this->datiCarrello["valoreBuonoSconto"] + $importoSpedizione;
            $query = "UPDATE geecEc_carrelli SET idSpedizione={$datiSpedizione["id"]}, importoSpedizione={$importoSpedizione}, importoTotale='{$importoTotale}' WHERE id={$this->datiCarrello["id"]}";
            $this->db->eseguiQueryScrittura($query);
        }
        
        // funzione che stampa il form di login
        function stampaModuloLogin() {
		?>
		<div class="col-lg-5" >
			<div class="card card-body text-white bg-primary">
				<h5><?= $this->gestoreTraduzioni->traduci("Già registrato? Accedi subito",$this->lingua) ?></h5>
				<form class=\"mt-3">
					<div class="form-group">
						<label for="emailLogin" >Email</label>
						<input type="text" class="form-control" id="emailLogin" placeholder="Email">
					</div>

					 <div class="form-group">
						<label for="password" >Password</label>
						<input type="password" class="form-control" id="password" placeholder="Password">
					</div>

					<div class="text-right">
						<button type="button" class="btn btn-outline-light leggi-tutto" onclick="loginPaginaCarrello()"></span>Accedi </button>
					</div>
				</form>
			</div>
		</div>
		<?php  
        }

        function stampaPulsanteConfermaOrdine() {
        	?>
            	<hr>
                <div class0"row">
                    <div class="col">
                        <div class="float-right">
                            <h3 class="accent">€ <span  id="labelTotaleCarrello"><?= $this->datiCarrello["importoTotale"] ?></span><button class="btn btn-primary float-right leggi-tutto ml-3 text-uppercase" onclick="trasformaCarrelloInOrdine()"><?= $this->gestoreTraduzioni->traduci("Completa l'ordine",$this->lingua) ?></button></h3>
                        </div>
                    </div>
                </div>
        	<?php
        }

        // funzione che stampa il testo di benvenuto dell'utente
        function stampaBenvenuto($sessioneUtente) {
            $utente = $this->db->leggiSingolaRiga("geec_utenti",$sessioneUtente);
            $nome = $utente["nome"];
            echo"<div class=col-md-6 >
            <h2>Benvenuto $nome</h2>";

            echo"<div class=\"form-group\">
                <div class=\"col-sm-offset-3 col-sm-9\">
                  <a href=areariservata/utenti/logout.php class=\"btn btn-primary\" onclick=\"loginPaginaCarrello()\"></span>Logout </a>
                  <a href=areariservata/pagina.php?id=2 class=\"btn btn-primary\" onclick=\"loginPaginaCarrello()\"></span>Profilo utente </a>
              </div></div>";
            echo"</div>";
        }
    }
